package com.ejie.ab04b.validation;

import java.util.ArrayList;
import java.util.List;

import com.ejie.ab04b.exception.ErrorField;

/**
 * Clase que deben extender todos los validadores.<br/>
 * Se <u>deben sobreescribir</u> de los metodos: <b>validateAdd, validateEdit y
 * validateAny</b>, los que se quieran utilizar.
 * 
 <T>
 *            Tipo de objeto para el que se realizan las validaciones
 * 
 * @author GFI-NORTE
 */
public abstract class AbstractValidator<T> {

	/**
	 * Tipo de operacion que se quiere validar: Añadir o Editar
	 */
	public static enum Oper {
		EDIT_TAB_PROC_ALMAC, EDIT_TAB_DATOS_OBRA, EDIT_TAB_DATOS_CENTRO, EDIT_TAB_NOTIFICACION, EDIT_TAB_DATOS_EMPRESA, MARCAR_VISITA_OSALAN, FILTER_LIST_ANUAL_MES_TER, FILTER_LIST_ANUAL_SEC_TER, EDIT_TAB_COORDINADORES
	}

	/**
	 * Method 'EntidadValidator'.
	 */
	protected AbstractValidator() {
		super();
	}

	/**
	 * Metodo validador para la operacion ADD_PRESENCIAL.
	 * 
	 *  errorFields            List<ErrorField>
	 *  object            T
	 * 
	 *            abstract void validateAddPresencial(List<ErrorField>
	 *            errorFields, T object);
	 *
	 * @param errorFields the error fields
	 * @param object the object
	 */

	/**
	 * Metodo validador para la operacion ADD_PRESENCIAL
	 * 
 errorFields
	 *            List<ErrorField>
 object
	 *            T
	 * 
	 *            abstract void validateAddTelematica(List<ErrorField>
	 *            errorFields, T object);
	 */

	/**
	 * Metodo validador para la operacion EDIT.
	 * 
 errorFields
	 *            List<ErrorField>
 object
	 *            T
	 * 
	 *            abstract void validateEdit(List<ErrorField> errorFields, T
	 *            object);
	 */

	/**
	 * Metodo validador para la operacion EDIT_TAB_DATOS_ERE.
	 * 
 errorFields
	 *            List<ErrorField>
 object
	 *            T
	 */
	abstract void validateEditTabProcAlmac(List<ErrorField> errorFields,
			T object);

	/**
	 * Metodo validador para la operacion EDIT_TAB_DATOS_ERE.
	 * 
	 *  errorFields
	 *            List<ErrorField>
	 *  object
	 *            T
	 *
	 * @param errorFields the error fields
	 * @param object the object
	 */
	abstract void validateEditTabDatosObra(List<ErrorField> errorFields,
			T object);

	/**
	 * Valida los datos obligatorios de la parte de los datos del expediente.
	 * 
	 *  errorFields            List<ErrorField>
	 *  object            T
	 *
	 * @param errorFields the error fields
	 * @param object the object
	 */
	abstract void validateEditTabDatosCentro(List<ErrorField> errorFields,
			T object);

	/**
	 * Valida los datos obligatorios de la parte de los datos del expediente.
	 * 
	 *  errorFields            List<ErrorField>
	 *  object            T
	 *
	 * @param errorFields the error fields
	 * @param object the object
	 */
	abstract void validateEditTabNotificacion(List<ErrorField> errorFields,
			T object);

	/**
	 * Valida los datos obligatorios de la parte de los datos del expediente.
	 * 
	 *  errorFields            List<ErrorField>
	 *  object            T
	 *
	 * @param errorFields the error fields
	 * @param object the object
	 */
	abstract void validateEditTabCoordinadores(List<ErrorField> errorFields,
			T object);

	/**
	 * Valida los datos obligatorios de la parte de los datos del expediente.
	 * 
	 *  errorFields            List<ErrorField>
	 *  object            T
	 *
	 * @param errorFields the error fields
	 * @param object the object
	 */
	abstract void validateEditTabDatosEmpresa(List<ErrorField> errorFields,
			T object);

	/**
	 * Valida los datos obligatorios de la parte de los datos del expediente.
	 * 
	 *  errorFields            List<ErrorField>
	 *  object            T
	 *
	 * @param errorFields the error fields
	 * @param object the object
	 */
	abstract void validatefilterListAnualMesTer(List<ErrorField> errorFields,
			T object);

	/**
	 * Valida los datos obligatorios de la parte de los datos del expediente.
	 * 
	 *  errorFields            List<ErrorField>
	 *  object            T
	 *
	 * @param errorFields the error fields
	 * @param object the object
	 */
	abstract void validatefilterListAnualSecTer(List<ErrorField> errorFields,
			T object);

	/**
	 * Valida los datos obligatorios de la parte de los datos del expediente.
	 * 
	 *  errorFields            List<ErrorField>
	 *  object            T
	 *
	 * @param errorFields the error fields
	 * @param object the object
	 */
	abstract void validateMarcarVisitaOsalan(List<ErrorField> errorFields,
			T object);
	
	/**
	 * Valida los datos obligatorios de la parte de los datos del expediente.
	 * 
	 *  errorFields            List<ErrorField>
	 *  object            T
	 *
	 * @param errorFields the error fields
	 * @param object the object
	 */
	abstract void validateLocalidadCP(List<ErrorField> errorFields,
			T object);
	
	/**
	 * Valida el model.
	 * 
	 *  object
	 *            Tipo
	 *  oper
	 *            Oper
	 *  List<ErrorField>
	 *
	 * @param object the object
	 * @param oper the oper
	 * @return the list
	 */
	public List<ErrorField> validate(T object, Oper oper) {
		List<ErrorField> errorFields = new ArrayList<ErrorField>();
		switch (oper) {
		case EDIT_TAB_PROC_ALMAC:
			this.validateEditTabProcAlmac(errorFields, object);
			break;
		case EDIT_TAB_DATOS_OBRA:
			this.validateEditTabDatosObra(errorFields, object);
			break;
		case EDIT_TAB_DATOS_CENTRO:
			this.validateEditTabDatosCentro(errorFields, object);
			break;
		case EDIT_TAB_COORDINADORES:
			this.validateEditTabCoordinadores(errorFields, object);
			break;
		case EDIT_TAB_NOTIFICACION:
			this.validateEditTabNotificacion(errorFields, object);
			break;
		case EDIT_TAB_DATOS_EMPRESA:
			this.validateEditTabDatosEmpresa(errorFields, object);
			break;
		case FILTER_LIST_ANUAL_MES_TER:
			this.validatefilterListAnualMesTer(errorFields, object);
			break;
		case FILTER_LIST_ANUAL_SEC_TER:
			this.validatefilterListAnualSecTer(errorFields, object);
			break;
		case MARCAR_VISITA_OSALAN:
			this.validateMarcarVisitaOsalan(errorFields, object);
			break;
		default:

			break;
		}
		return errorFields;
	}
	
	/**
	 * Valida el model.
	 * 
	 *  object
	 *            Tipo
	 *  List<ErrorField>
	 *
	 * @param object the object
	 * @return the list
	 */
	public List<ErrorField> validateLocalidadCP(T object) {
		List<ErrorField> errorFields = new ArrayList<ErrorField>();
		
		this.validateLocalidadCP(errorFields, object);
		
		return errorFields;
	}
}